/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.annotation.Preprocessor;
import com.blamejared.crafttweaker.api.natives.NativeTypeInfo;
import com.blamejared.crafttweaker.api.plugin.IJavaNativeIntegrationRegistrationHandler;
import com.blamejared.crafttweaker.api.util.InstantiationUtil;
import com.blamejared.crafttweaker.api.zencode.IPreprocessor;
import com.blamejared.crafttweaker.api.zencode.ZenTypeInfo;
import com.blamejared.crafttweaker.impl.plugin.crafttweaker.AnnotationsToApiConverters;
import com.blamejared.crafttweaker_annotations.annotations.NativeMethod;
import com.blamejared.crafttweaker_annotations.annotations.NativeTypeRegistration;
import com.blamejared.crafttweaker_annotations.annotations.TypedExpansion;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import org.openzen.zencode.java.ZenCodeType;

final class ZenClassRegistrationManager {
    private final AnnotationsToApiConverters converters = new AnnotationsToApiConverters();
    private final Map<Class<?>, NativeTypeInfo> foundNatives = new HashMap();
    private final Queue<LateRegistrationCandidate> lateRegistrations = new ArrayDeque<LateRegistrationCandidate>();

    ZenClassRegistrationManager() {
    }

    void attemptRegistration(String loader, Class<?> clazz, IJavaNativeIntegrationRegistrationHandler handler) {
        this.attemptNativeRegistration(clazz, loader, handler);
        this.attemptZenRegistration(clazz, loader, handler);
        this.attemptPreprocessorRegistration(clazz, loader, handler);
    }

    void attemptDeferredRegistration(IJavaNativeIntegrationRegistrationHandler handler) {
        this.lateRegistrations.forEach(it -> it.callback().callback(it.clazz(), it.loader(), handler));
        this.lateRegistrations.clear();
    }

    private void attemptNativeRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        NativeTypeRegistration ntr = clazz.getDeclaredAnnotation(NativeTypeRegistration.class);
        if (ntr == null) {
            return;
        }
        NativeMethod[] methods = (NativeMethod[])clazz.getDeclaredAnnotationsByType(NativeMethod.class);
        NativeTypeInfo nativeTypeInfo = this.converters.toNativeTypeInfo(ntr, methods);
        this.foundNatives.put(nativeTypeInfo.targetedType(), nativeTypeInfo);
        handler.registerNativeType(loader, clazz, nativeTypeInfo);
    }

    private void attemptZenRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        this.attemptZenClassRegistration(clazz, loader, handler);
        this.attemptZenExpandRegistration(clazz, loader, handler);
        this.orFuture(clazz, loader, handler, this::attemptTypedExpandRegistration);
    }

    private void attemptZenClassRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        ZenCodeType.Name name = clazz.getDeclaredAnnotation(ZenCodeType.Name.class);
        if (name == null) {
            return;
        }
        ZenTypeInfo typeInfo = this.converters.toZenTypeInfo(name);
        handler.registerZenClass(loader, clazz, typeInfo);
        handler.registerGlobalsIn(loader, clazz, typeInfo);
    }

    private void attemptZenExpandRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        ZenCodeType.Expansion expansion = clazz.getDeclaredAnnotation(ZenCodeType.Expansion.class);
        if (expansion == null) {
            return;
        }
        handler.registerZenClass(loader, clazz, this.converters.toZenTypeInfo(expansion));
    }

    private void attemptTypedExpandRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        TypedExpansion expansion = clazz.getDeclaredAnnotation(TypedExpansion.class);
        if (expansion == null) {
            return;
        }
        Class<?> target = expansion.value();
        String targetName = this.figureOutTypedExpansionName(target);
        if (targetName == null) {
            throw new IllegalStateException("Unable to register typed expansion for unknown type " + clazz.getName());
        }
        handler.registerZenClass(loader, clazz, new ZenTypeInfo(targetName, ZenTypeInfo.TypeKind.EXPANSION));
    }

    private void attemptPreprocessorRegistration(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler) {
        Preprocessor preprocessor = clazz.getDeclaredAnnotation(Preprocessor.class);
        if (preprocessor == null) {
            return;
        }
        handler.registerPreprocessor((IPreprocessor)InstantiationUtil.getOrCreateInstance(clazz));
    }

    private void orFuture(Class<?> clazz, String loader, IJavaNativeIntegrationRegistrationHandler handler, LateCallback callback) {
        try {
            callback.callback(clazz, loader, handler);
        }
        catch (Exception e) {
            this.lateRegistrations.add(new LateRegistrationCandidate(clazz, loader, callback));
        }
    }

    private String figureOutTypedExpansionName(Class<?> target) {
        NativeTypeRegistration registration = target.getDeclaredAnnotation(NativeTypeRegistration.class);
        if (registration != null) {
            return registration.zenCodeName();
        }
        ZenCodeType.Name name = target.getDeclaredAnnotation(ZenCodeType.Name.class);
        if (name != null) {
            return name.value();
        }
        NativeTypeInfo knownNative = this.foundNatives.get(target);
        if (knownNative != null) {
            return knownNative.name();
        }
        return null;
    }

    @FunctionalInterface
    private static interface LateCallback {
        public void callback(Class<?> var1, String var2, IJavaNativeIntegrationRegistrationHandler var3);
    }

    private record LateRegistrationCandidate(Class<?> clazz, String loader, LateCallback callback) {
    }
}

